//
//  Mammifere.cpp
//  Séance 4
//
//  Created by Nicolas Sicard on 23/10/2015.
//  Copyright © 2015 Efrei. All rights reserved.
//

#include "Mammifere.hpp"


Mammifere::Mammifere(const string& nom) { _nom = nom; _dateDeNaissance = new Date(5, 4, 2005); }
Mammifere::Mammifere(const Mammifere& m) {
    _nom = m._nom;
    _dateDeNaissance = new Date(*(m._dateDeNaissance));
}

Mammifere::~Mammifere() { delete _dateDeNaissance; }

Mammifere& Mammifere::operator=(const Mammifere& m)
{
    if (this != &m) {
        _nom = m._nom;
        delete _dateDeNaissance;
        _dateDeNaissance = new Date(*(m._dateDeNaissance));
    }
    return *this;
}


string Mammifere::getNom() const { return _nom; }

void Mammifere::setNom(const string& nom) { _nom = nom; }

void Mammifere::se_deplace() { cout << _nom << " se déplace..."; }

void Mammifere::print() const { cout << "Mammifere : " << _nom << endl; }

ostream& operator<<(ostream& os, const Mammifere& m)
{
    os << m._nom;
    return os;
}